//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Reflection;
using System.Collections;
using System.Security.Permissions;
using System.Runtime.Serialization;

namespace AssemblySample
{

	class AssemblySampleMain
	{
		static void Main(string[] args)
		{
			try
			{
				// Assembly a = Assembly.Load("SubAssembly, SN=d8d19842315c20be");
				// Assembly a = Assembly.LoadFrom(@"..\..\SubAssembly\bin\debug\SubAssembly.dll");
				// Assembly a = Assembly.LoadFrom(@"..\..\bin\debug\SubAssembly.dll");
				Console.WriteLine(Assembly.CreateQualifiedName("SubAssembly", "MyClass"));
				Assembly a = Assembly.Load("SubAssembly");
				Console.WriteLine("Lista wszystkich typw dla");
				Console.WriteLine(" {0}", a.FullName);
				Type [] types = a.GetTypes();
				foreach(Type t in types)
				{
					Console.WriteLine("Type: {0}", t);
				}
				Module [] modules = a.GetLoadedModules();
				foreach(Module m in modules)
				{
					Console.WriteLine("Zaadowane moduy: {0}", m);
				}

				Console.WriteLine("CodeBase: {0}", a.CodeBase);
				Console.WriteLine("Pooenie: {0}", a.Location);
				Console.WriteLine("Punkt wejcia: {0}", a.EntryPoint);
				Console.WriteLine("Liczba dowodw: {0}", a.Evidence.Count);
				IEnumerator ee = a.Evidence.GetEnumerator();
				while(ee.MoveNext())
				{
					Console.WriteLine(ee.Current);
				}
				Console.WriteLine("Plik zaadowany z GAC: {0}", a.GlobalAssemblyCache);
				Object [] attributes = a.GetCustomAttributes(true);
				foreach(object o in attributes)
				{
					Console.WriteLine(o);
				}
				TypeSampler.MyClass mc = new TypeSampler.MyClass();
				Console.WriteLine("MyInt to: {0}", mc.MyInt);

				AssemblyName [] assemblyNames = a.GetReferencedAssemblies();
				foreach(AssemblyName an in assemblyNames)
				{
					Console.WriteLine("Odwoania: {0}", an.Name);
				}
				a = Assembly.GetAssembly(typeof(double));
				Console.WriteLine(a.FullName);
				a = Assembly.GetAssembly(typeof(TypeSampler.MyClass));
				Console.WriteLine(a.FullName);
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}
		}
	}
}
